# analysis by looping over markers, first without (taking into account peak heights) 
# and  then with presence.only (based only on allele values) 

t1<-Sys.time()
cat('\nUsing peak heights\n\n')
loop.rpt.IBD(list(epg),pars,'parent',list(d=Dgt),targets=c('f','d'),contribs=c('f','u'),
             k=2,C=rep(list(C),length(list(epg))),database=db, quiet=TRUE,verbose=TRUE)

t2<-Sys.time()
print(difftime(t2,t1))
cat('\nUsing presence only\n\n')
loop.rpt.IBD(list(epg),pars,'parent',list(d=Dgt),targets=c('f','d'),contribs=c('f','u'),
             k=2,C=rep(list(C),length(list(epg))),database=db,quiet=TRUE,verbose=TRUE,presence.only=TRUE)
t3<-Sys.time()
print(difftime(t3,t2))

# partial logLR's, omitting Markers 8 and 10

t1<-Sys.time()
cat('\nUsing peak heights, omitting Markers 8 and 10\n\n')
loop.rpt.IBD(list(subset(epg,!marker%in%c('Marker08','Marker10'))),pars,'parent',list(d=Dgt),
		targets=c('f','d'),contribs=c('f','u'),
		k=2,C=rep(list(C),length(list(epg))),database=db, quiet=TRUE,verbose=TRUE)
t2<-Sys.time()
print(difftime(t2,t1))

cat('\nUsing presence only, omitting Markers 8 and 10\n\n')
loop.rpt.IBD(list(subset(epg,!marker%in%c('Marker08','Marker10'))),pars,'parent',list(d=Dgt),
		targets=c('f','d'),contribs=c('f','u'),
		k=2,C=rep(list(C),length(list(epg))),database=db, quiet=TRUE,verbose=TRUE,presence.only=TRUE)
t3<-Sys.time()
print(difftime(t3,t2))

## to relMix...

cat('\nUsing relMix\n\n')

require(relMix)

t1<-Sys.time()
#Define pedigrees
persons <- c("C","M","F","U1","U2")
ped1 <- Familias::FamiliasPedigree(id=c(persons), dadid=c("F",NA, NA,NA,NA), momid=c(NA, NA,NA,NA,NA),
                                   sex=c("female", "female", "male","male","male"))
ped2 <- Familias::FamiliasPedigree(id=c(persons), dadid=c(NA,NA, NA,NA,NA), momid=c(NA, NA,NA,NA,NA),
                                   sex=c("male", "female", "male","male","male"))
LR<-1

for(m in setdiff(unique(epg$marker),c('Marker08','Marker10'))) ##To avoid markers where relMix fails
{
cat(m,' ')
dfr<-extract(db,epg,c('Dgt'),50,m)[[m]]
locus<-Familias::FamiliasLocus(frequencies=dfr$freq,name=m,allelenames=dfr$alleles)
datamatrix1 <- createDatamatrix(locus,knownGenos=list(C=dfr$Dgt),idsU=c("F","U1"))
datamatrix2 <- createDatamatrix(locus,knownGenos=list(C=dfr$Dgt),idsU=c("U1","U2"))
d <- 0.1
di <- 0.05
res1 <- relMix(list(Hp=ped1), locus, dfr$R, datamatrix1, ids=c("F","U1"), D=list(c(0,0),c(d,d^2)),di=di, kinship=0)
res2 <- relMix(list(Hd=ped2), locus, dfr$R, datamatrix2, ids=c("U1","U2"), D=list(c(0,0),c(d,d^2)),di=di, kinship=0)
cat(res1$Hp/res2$Hd,'\n')
LR<-LR*res1$Hp/res2$Hd
}
cat('all trace all marker overall log10 LR:',log10(LR),'LR:',LR,'\n')
t2<-Sys.time()
print(difftime(t2,t1))

